/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.ui.layout.components;

import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.betterx.ui.layout.components.AbstractVerticalStack;
import org.betterx.ui.layout.components.Button;
import org.betterx.ui.layout.components.Container;
import org.betterx.ui.layout.components.HorizontalStack;
import org.betterx.ui.layout.components.LayoutComponent;
import org.betterx.ui.layout.values.Value;

@Environment(value=EnvType.CLIENT)
public class Tabs
extends AbstractVerticalStack<Tabs> {
    private final HorizontalStack buttons;
    private final Container content;
    private final List<Container> pageList = new LinkedList<Container>();
    private final List<Button> buttonList = new LinkedList<Button>();
    private int initialPage = 0;
    private OnPageChange onPageChange;

    public Tabs(Value width, Value height) {
        super(width, height);
        this.buttons = new HorizontalStack(Value.fill(), Value.fit());
        this.content = new Container(Value.fill(), Value.fill());
        this.add(this.buttons);
        this.add(this.content);
        this.setBackgroundColor(0x77000000);
        this.setPadding(4);
    }

    public Tabs addPage(class_2561 title, LayoutComponent<?, ?> content) {
        Container c = new Container(Value.fill(), Value.fill());
        c.addChild(content);
        this.content.addChild(c);
        this.pageList.add(c);
        if (!this.buttons.isEmpty()) {
            this.buttons.addSpacer(4);
        }
        Button b = (Button)new Button(Value.fit(), Value.fit(), title).alignBottom();
        b.onPress(bt -> {
            for (Container cc : this.pageList) {
                cc.setVisible(cc == c);
            }
            for (Button bb : this.buttonList) {
                bb.glow = bb == b;
            }
            if (this.onPageChange != null) {
                for (int i = 0; i < this.buttonList.size(); ++i) {
                    if (!this.buttonList.get((int)i).glow) continue;
                    this.onPageChange.now(this, i);
                }
            }
        });
        this.buttons.add((LayoutComponent)b);
        this.buttonList.add(b);
        return this;
    }

    public Tabs onPageChange(OnPageChange e) {
        this.onPageChange = e;
        return this;
    }

    public Button getButton(int idx) {
        return this.buttonList.get(idx);
    }

    public Tabs setBackgroundColor(int color) {
        this.content.setBackgroundColor(color);
        return this;
    }

    public int getBackgroundColor() {
        return this.content.getBackgroundColor();
    }

    public Tabs setOutlineColor(int color) {
        this.content.setOutlineColor(color);
        return this;
    }

    public int getOutlineColor() {
        return this.content.getOutlineColor();
    }

    public Tabs setPadding(int padding) {
        this.content.setPadding(padding);
        return this;
    }

    public Tabs setPadding(int left, int top, int right, int bottom) {
        this.content.setPadding(left, top, right, bottom);
        return this;
    }

    @Override
    public int getContentWidth() {
        return this.content.getContentWidth();
    }

    public Tabs selectPage(int idx) {
        for (int i = 0; i < this.pageList.size(); ++i) {
            this.pageList.get(i).setVisible(i == idx);
            this.buttonList.get((int)i).glow = i == idx;
        }
        this.initialPage = idx;
        return this;
    }

    public int getSelectedPage() {
        return this.initialPage;
    }

    public Tabs addComponent(LayoutComponent<?, ?> title) {
        this.buttons.add((LayoutComponent)title);
        return this;
    }

    @Override
    protected void onBoundsChanged() {
        super.onBoundsChanged();
        this.selectPage(this.initialPage);
    }

    @Override
    public Tabs addFiller() {
        this.buttons.addFiller();
        return this;
    }

    @Override
    public Tabs addSpacer(int size) {
        this.buttons.addSpacer(size);
        return this;
    }

    @Override
    public Tabs addSpacer(float percentage) {
        this.buttons.addSpacer(percentage);
        return this;
    }

    @FunctionalInterface
    public static interface OnPageChange {
        public void now(Tabs var1, int var2);
    }
}

